
library(memisc)


library(mclogit)


load("model-relmemb-soclife-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_soclife <- mtable(model_soclife,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "Social lifestyle" = c("Squared" = "sociallifestyle.sq",                        
                                                "Linear"  = "sociallifestyle",                           
                                                "$\\times$ non-Christian"  = "sociallifestyle:relmembNon-Christian",      
                                                "$\\times$ no religion"    = "sociallifestyle:relmembNo religion",        
                                                "$\\times$ self-employed"  = "sociallifestyle:oesch8Self-employed",       
                                                "$\\times$ technical"      = "sociallifestyle:oesch8Technical",           
                                                "$\\times$ management"     = "sociallifestyle:oesch8Management",          
                                                "$\\times$ clerks"         = "sociallifestyle:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "sociallifestyle:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "sociallifestyle:oesch8Service worker",      
                                                "$\\times$ primary sector" = "sociallifestyle:oesch8Primary sector",      
                                                "$\\times$ secularization" = "sociallifestyle:Secularization", 
                                                "$\\times$ non-Christian $\\times$ secularization"  = "sociallifestyle:relmembNon-Christian:Secularization", 
                                                "$\\times$ no religion $\\times$ secularization"    = "sociallifestyle:relmembNo religion:Secularization",
                                                "$\\times$ time" = "sociallifestyle:time", 
                                                "$\\times$ non-Christian $\\times$ time"  = "sociallifestyle:relmembNon-Christian:time", 
                                                "$\\times$ no religion $\\times$ time"    = "sociallifestyle:relmembNo religion:time",
                                                "$\\times$ self-employed $\\times$ time"  = "sociallifestyle:oesch8Self-employed:time",  
                                                "$\\times$ technical $\\times$ time"      = "sociallifestyle:oesch8Technical:time",      
                                                "$\\times$ management $\\times$ time"     = "sociallifestyle:oesch8Management:time",     
                                                "$\\times$ clerks $\\times$ time"         = "sociallifestyle:oesch8Clerks:time",         
                                                "$\\times$ socio-cultural $\\times$ time" = "sociallifestyle:oesch8Socio-cultural:time", 
                                                "$\\times$ service worker $\\times$ time" = "sociallifestyle:oesch8Service worker:time", 
                                                "$\\times$ primary sector $\\times$ time" = "sociallifestyle:oesch8Primary sector:time"),                                  
                            "Immigration" = c("Squared" = "immigration.sq",                                 
                                              "Linear"  = "immigration",               
                                              "$\\times$ non-Christian"  = "relmembNon-Christian:immigration",               
                                              "$\\times$ no religion"    = "relmembNo religion:immigration",                                    
                                              "$\\times$ self-employed"  = "oesch8Self-employed:immigration",                
                                              "$\\times$ technical"      = "oesch8Technical:immigration",                    
                                              "$\\times$ management"     = "oesch8Management:immigration",                   
                                              "$\\times$ clerks"         = "oesch8Clerks:immigration",                       
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:immigration",               
                                              "$\\times$ service worker" = "oesch8Service worker:immigration",               
                                              "$\\times$ primary sector" = "oesch8Primary sector:immigration",                 
                                              "$\\times$ time" = "time:immigration",          
                                              "$\\times$ non-Christian $\\times$ time"  = "relmembNon-Christian:time:immigration",          
                                              "$\\times$ no religion $\\times$ time"    = "relmembNo religion:time:immigration",                               
                                              "$\\times$ self-employed $\\times$ time"  = "oesch8Self-employed:time:immigration",           
                                              "$\\times$ technical $\\times$ time"      = "oesch8Technical:time:immigration",               
                                              "$\\times$ management $\\times$ time"     = "oesch8Management:time:immigration",              
                                              "$\\times$ clerks $\\times$ time"         = "oesch8Clerks:time:immigration",                  
                                              "$\\times$ socio-cultural $\\times$ time" = "oesch8Socio-cultural:time:immigration",          
                                              "$\\times$ service worker $\\times$ time" = "oesch8Service worker:time:immigration",          
                                              "$\\times$ primary sector $\\times$ time" = "oesch8Primary sector:time:immigration"),   
                            "Economic Left--Right"= c("Squared" = "lrecon.sq",                                 
                                                  "Linear"  = "lrecon",                                         
                                                 "$\\times$ non-Christian"  = "relmembNon-Christian:lrecon",               
                                                 "$\\times$ no religion"    = "relmembNo religion:lrecon",                                    
                                                 "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",                     
                                                 "$\\times$ technical"      = "oesch8Technical:lrecon",                         
                                                 "$\\times$ management"     = "oesch8Management:lrecon",                        
                                                 "$\\times$ clerks"         = "oesch8Clerks:lrecon",                            
                                                 "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",                    
                                                 "$\\times$ service worker" = "oesch8Service worker:lrecon",                    
                                                 "$\\times$ primary sector" = "oesch8Primary sector:lrecon",                    
                                                 "$\\times$ time" = "time:lrecon",          
                                                 "$\\times$ non-Christian $\\times$ time"  = "relmembNon-Christian:time:lrecon",          
                                                 "$\\times$ no religion $\\times$ time"    = "relmembNo religion:time:lrecon",                                    
                                                 "$\\times$ self-employed $\\times$ time"  = "oesch8Self-employed:time:lrecon",                
                                                 "$\\times$ technical $\\times$ time"      = "oesch8Technical:time:lrecon",                    
                                                 "$\\times$ management $\\times$ time"     = "oesch8Management:time:lrecon",                   
                                                 "$\\times$ clerks $\\times$ time"         = "oesch8Clerks:time:lrecon",                       
                                                 "$\\times$ socio-cultural $\\times$ time" = "oesch8Socio-cultural:time:lrecon",               
                                                 "$\\times$ service worker $\\times$ time" = "oesch8Service worker:time:lrecon",               
                                                 "$\\times$ primary sector $\\times$ time" = "oesch8Primary sector:time:lrecon")
                        )))



m_soclife


m_soclife |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="relmemb-context-soclife/mtable-relmemb-context-soclife.tex")




